/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.PdfSignatureField;
import eu.europa.esig.dss.pades.validation.timestamp.PdfTimestampToken;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfDocTimestampRevision
extends PdfCMSRevision {
    private static final long serialVersionUID = -1526261963945359026L;
    private static final Logger LOG = LoggerFactory.getLogger(PdfDocTimestampRevision.class);
    private final PdfTimestampToken timestampToken;

    public PdfDocTimestampRevision(PdfSignatureDictionary signatureDictionary, List<PdfSignatureField> timestampFields, DSSDocument signedContent, boolean coverCompleteRevision) {
        super(signatureDictionary, timestampFields, signedContent, coverCompleteRevision);
        try {
            this.timestampToken = new PdfTimestampToken(this);
            this.timestampToken.matchData(this.getSignedData());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created PdfDocTimestampInfo : {}", (Object)this.getByteRange());
            }
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to create a PdfDocTimestampRevision : %s", e.getMessage()), e);
        }
    }

    @Override
    public Date getSigningDate() {
        return this.timestampToken.getGenerationTime();
    }

    public PdfTimestampToken getTimestampToken() {
        return this.timestampToken;
    }
}

