/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.pdfbox.PdfBoxDocumentReader;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;

public class PdfBoxUtils {
    private PdfBoxUtils() {
    }

    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, int page) {
        return PdfBoxUtils.generateScreenshot(pdfDocument, null, page);
    }

    public static DSSDocument generateScreenshot(DSSDocument pdfDocument, String passwordProtection, int page) {
        BufferedImage bufferedImage = PdfBoxUtils.generateBufferedImageScreenshot(pdfDocument, passwordProtection, page);
        return ImageUtils.toDSSDocument(bufferedImage);
    }

    public static BufferedImage generateBufferedImageScreenshot(DSSDocument pdfDocument, String passwordProtection, int page) {
        BufferedImage bufferedImage;
        Objects.requireNonNull(pdfDocument, "pdfDocument shall be defined!");
        PdfBoxDocumentReader reader = new PdfBoxDocumentReader(pdfDocument, passwordProtection);
        try {
            bufferedImage = reader.generateImageScreenshot(page);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("Unable to generate a screenshot for the document with name '%s' for the page number '%s'. Reason : %s", pdfDocument.getName(), page, e.getMessage()), e);
            }
        }
        reader.close();
        return bufferedImage;
    }

    public static DSSDocument generateSubtractionImage(DSSDocument document1, DSSDocument document2, int page) {
        return PdfBoxUtils.generateSubtractionImage(document1, null, page, document2, null, page);
    }

    public static DSSDocument generateSubtractionImage(DSSDocument document1, String passwordDocument1, int pageDocument1, DSSDocument document2, String passwordDocument2, int pageDocument2) {
        BufferedImage screenshotDoc1 = PdfBoxUtils.generateBufferedImageScreenshot(document1, passwordDocument1, pageDocument1);
        BufferedImage screenshotDoc2 = PdfBoxUtils.generateBufferedImageScreenshot(document2, passwordDocument2, pageDocument2);
        int width = Math.max(screenshotDoc1.getWidth(), screenshotDoc2.getWidth());
        int height = Math.max(screenshotDoc1.getHeight(), screenshotDoc2.getHeight());
        BufferedImage outputImage = PdfBoxUtils.getOutputImage(width, height);
        ImageUtils.drawSubtractionImage(screenshotDoc1, screenshotDoc2, outputImage);
        return ImageUtils.toDSSDocument(outputImage);
    }

    private static BufferedImage getOutputImage(int width, int height) {
        BufferedImage outputImage = new BufferedImage(width, height, 1);
        Graphics2D drawer = outputImage.createGraphics();
        drawer.setBackground(Color.WHITE);
        drawer.clearRect(0, 0, width, height);
        return outputImage;
    }
}

