/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.x509.aia;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.jdbc.JdbcCacheConnector;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.aia.RepositoryAIASource;
import eu.europa.esig.dss.utils.Utils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheAIASource
extends RepositoryAIASource {
    private static final long serialVersionUID = -4332455769204417938L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheAIASource.class);
    private static final String SQL_INIT_CHECK_EXISTENCE = "SELECT COUNT(*) FROM AIA_CERTIFICATES";
    private static final String SQL_INIT_CREATE_TABLE = "CREATE TABLE AIA_CERTIFICATES (ID CHAR(40), AIA CHAR(40), DATA BLOB)";
    private static final String SQL_FIND_QUERY = "SELECT * FROM AIA_CERTIFICATES WHERE AIA = ?";
    private static final String SQL_FIND_QUERY_ID = "ID";
    private static final String SQL_FIND_QUERY_AIA = "AIA";
    private static final String SQL_FIND_QUERY_DATA = "DATA";
    private static final String SQL_FIND_INSERT = "INSERT INTO AIA_CERTIFICATES (ID, AIA, DATA) VALUES (?, ?, ?)";
    private static final String SQL_FIND_REMOVE = "DELETE FROM AIA_CERTIFICATES WHERE AIA = ?";
    private static final String SQL_DROP_TABLE = "DROP TABLE AIA_CERTIFICATES";
    private static final String SQL_DISTINCT_AIA_KEYS_QUERY = "SELECT DISTINCT AIA FROM AIA_CERTIFICATES";
    private static List<JdbcCacheConnector.JdbcResultRequest> findCertificatesRequests = new ArrayList<JdbcCacheConnector.JdbcResultRequest>();
    private static List<JdbcCacheConnector.JdbcResultRequest> findAIAKeysRequests;
    protected transient JdbcCacheConnector jdbcCacheConnector;

    public void setJdbcCacheConnector(JdbcCacheConnector jdbcCacheConnector) {
        this.jdbcCacheConnector = jdbcCacheConnector;
    }

    @Override
    protected Set<CertificateToken> findCertificates(String key) {
        Collection<JdbcCacheConnector.JdbcResultRecord> records = this.jdbcCacheConnector.select(SQL_FIND_QUERY, findCertificatesRequests, key);
        return this.buildCertificatesFromResult(records);
    }

    private Set<CertificateToken> buildCertificatesFromResult(Collection<JdbcCacheConnector.JdbcResultRecord> records) {
        try {
            LinkedHashSet<CertificateToken> certificateTokens = new LinkedHashSet<CertificateToken>();
            for (JdbcCacheConnector.JdbcResultRecord resultRecord : records) {
                CertificateToken certificateToken;
                byte[] binaries = (byte[])resultRecord.get(SQL_FIND_QUERY_DATA);
                if (!Utils.isArrayNotEmpty(binaries) || (certificateToken = DSSUtils.loadCertificate(binaries)) == null) continue;
                certificateTokens.add(certificateToken);
            }
            return certificateTokens;
        }
        catch (Exception e) {
            throw new DSSExternalResourceException(String.format("An error occurred during an attempt to get a certificate token from cache. Reason : %s", e.getMessage()), e);
        }
    }

    @Override
    protected void insertCertificates(String aiaUrl, Collection<CertificateToken> certificateTokens) {
        if (Utils.isCollectionNotEmpty(certificateTokens)) {
            for (CertificateToken certificate : certificateTokens) {
                this.jdbcCacheConnector.execute(SQL_FIND_INSERT, this.getUniqueCertificateAiaId(certificate, aiaUrl), this.getAiaUrlIdentifier(aiaUrl), certificate.getEncoded());
                LOG.debug("AIA Certificate with Id '{}' successfully inserted in DB", (Object)certificate.getDSSIdAsString());
            }
        }
    }

    private String getUniqueCertificateAiaId(CertificateToken certificateToken, String aiaUrl) {
        return DSSUtils.getSHA1Digest(certificateToken.getDSSIdAsString() + aiaUrl);
    }

    private String getAiaUrlIdentifier(String aiaUrl) {
        return DSSUtils.getSHA1Digest(aiaUrl);
    }

    @Override
    protected void removeCertificates(String aiaKey) {
        this.jdbcCacheConnector.execute(SQL_FIND_REMOVE, aiaKey);
        LOG.debug("Certificate tokens with AIA key '{}' successfully removed from DB", (Object)aiaKey);
    }

    @Override
    protected List<String> getExistingAIAKeys() {
        Collection<JdbcCacheConnector.JdbcResultRecord> result = this.jdbcCacheConnector.select(SQL_DISTINCT_AIA_KEYS_QUERY, findAIAKeysRequests, new Object[0]);
        return result.stream().map(r -> (String)r.get(SQL_FIND_QUERY_AIA)).collect(Collectors.toList());
    }

    public void initTable() throws SQLException {
        if (!this.isTableExists()) {
            LOG.debug("Table does not exist. Creating a new table...");
            this.createTable();
            LOG.info("Table was created.");
        } else {
            LOG.debug("Table already exists.");
        }
    }

    public boolean isTableExists() {
        return this.jdbcCacheConnector.tableQuery(SQL_INIT_CHECK_EXISTENCE);
    }

    private void createTable() throws SQLException {
        this.jdbcCacheConnector.executeThrowable(SQL_INIT_CREATE_TABLE);
    }

    public void destroyTable() throws SQLException {
        if (this.isTableExists()) {
            LOG.debug("Table exists. Removing the table...");
            this.dropTable();
            LOG.info("Table was destroyed.");
        } else {
            LOG.warn("Cannot drop the table. Table does not exist.");
        }
    }

    private void dropTable() throws SQLException {
        this.jdbcCacheConnector.executeThrowable(SQL_DROP_TABLE);
    }

    static {
        findCertificatesRequests.add(new JdbcCacheConnector.JdbcResultRequest(SQL_FIND_QUERY_AIA, String.class));
        findCertificatesRequests.add(new JdbcCacheConnector.JdbcResultRequest(SQL_FIND_QUERY_DATA, byte[].class));
        findAIAKeysRequests = new ArrayList<JdbcCacheConnector.JdbcResultRequest>();
        findAIAKeysRequests.add(new JdbcCacheConnector.JdbcResultRequest(SQL_FIND_QUERY_AIA, String.class));
    }
}

