/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureIntegrityValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureIntegrityValidator.class);
    private List<String> errorMessages = null;

    public CertificateValidity validate(CandidatesForSigningCertificate candidates) {
        this.errorMessages = new ArrayList<String>();
        if (candidates.isEmpty()) {
            this.errorMessages.add("There is no signing certificate within the signature or certificate pool.");
        }
        LOG.debug("Determining signing certificate from certificate candidates list...");
        CertificateValidity bestCandidate = candidates.getTheBestCandidate();
        if (bestCandidate != null) {
            try {
                if (this.isSignatureIntact(bestCandidate)) {
                    return bestCandidate;
                }
                this.errorMessages.add("Signature verification failed against the best candidate.");
            }
            catch (DSSException e) {
                LOG.debug("Exception while probing the best candidate certificate as signing certificate: {}", (Object)e.getMessage());
                this.errorMessages.add("Best candidate validation failed : " + e.getMessage());
            }
        }
        CertificateValidity bestCertificateValidity = null;
        boolean coreValidity = false;
        int certificateNumber = 0;
        List<CertificateValidity> certificateValidityList = candidates.getCertificateValidityList();
        for (CertificateValidity certificateValidity : certificateValidityList) {
            if (certificateValidity == bestCandidate) continue;
            String errorMessagePrefix = "Certificate #" + (certificateNumber + 1) + ": ";
            try {
                if (this.isSignatureIntact(certificateValidity)) {
                    bestCertificateValidity = certificateValidity;
                    if (certificateValidity.isValid()) {
                        LOG.info("Determining signing certificate from certificate candidates list succeeded : {}", (Object)certificateValidity.getCertificateToken().getDSSIdAsString());
                        break;
                    }
                    if (certificateValidity.getCertificateToken() != null) {
                        LOG.warn("The signing certificate candidate '{}' does not match a signing certificate reference!", (Object)certificateValidity.getCertificateToken().getDSSIdAsString());
                    }
                } else {
                    this.errorMessages.add(errorMessagePrefix + "Signature verification failed");
                }
            }
            catch (DSSException e) {
                LOG.debug("Exception while probing candidate certificate as signing certificate: {}", (Object)e.getMessage());
                this.errorMessages.add(errorMessagePrefix + e.getMessage());
            }
            ++certificateNumber;
        }
        if (!coreValidity) {
            LOG.warn("Determining signing certificate from certificate candidates list failed: {}", (Object)this.errorMessages);
        }
        return bestCertificateValidity;
    }

    private boolean isSignatureIntact(CertificateValidity certificateValidity) {
        PublicKey publicKey = certificateValidity.getPublicKey();
        if (this.verify(publicKey)) {
            LOG.debug("Public key matching the signature value found.");
            return true;
        }
        return false;
    }

    protected abstract boolean verify(PublicKey var1) throws DSSException;

    public List<String> getErrorMessages() {
        if (this.errorMessages == null) {
            throw new IllegalStateException("The validate(candiates) method shall be proceeded before!");
        }
        return this.errorMessages;
    }
}

