/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.builder;

import eu.europa.esig.dss.tsl.cache.CachedResult;
import eu.europa.esig.dss.tsl.cache.state.CacheStateEnum;
import eu.europa.esig.dss.tsl.cache.state.CachedEntry;
import eu.europa.esig.dss.tsl.dto.AbstractCacheDTO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheDTOBuilder<R extends CachedResult> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCacheDTOBuilder.class);
    private final CachedEntry<R> cachedEntry;

    protected AbstractCacheDTOBuilder(CachedEntry<R> cachedEntry) {
        this.cachedEntry = cachedEntry;
    }

    public AbstractCacheDTO build() {
        AbstractCacheDTO abstractCacheDTO = new AbstractCacheDTO();
        abstractCacheDTO.setCacheState(this.getCurrentState());
        abstractCacheDTO.setLastStateTransitionTime(this.getLastStateTransitionTime());
        abstractCacheDTO.setLastSuccessSynchronizationTime(this.getLastSuccessSynchronizationTime());
        abstractCacheDTO.setExceptionMessage(this.getCachedExceptionMessage());
        abstractCacheDTO.setExceptionStackTrace(this.getCachedExceptionStackTrace());
        abstractCacheDTO.setExceptionFirstOccurrenceTime(this.getCachedExceptionFirstOccurrenceTime());
        abstractCacheDTO.setExceptionLastOccurrenceTime(this.getCachedExceptionLastOccurrenceTime());
        abstractCacheDTO.setResultExist(this.isResultExist());
        return abstractCacheDTO;
    }

    protected final R getResult() {
        return this.cachedEntry.getCachedResult();
    }

    protected boolean isResultExist() {
        boolean resultExist;
        boolean bl = resultExist = this.getResult() != null;
        if (resultExist) {
            LOG.trace("The result exists in the cache. The related parameters will be filled in the DTO.");
        } else {
            LOG.debug("The result does not exist for the entry in the cache. The specifiic parameters are not filled!");
        }
        return resultExist;
    }

    private CacheStateEnum getCurrentState() {
        return this.cachedEntry.getCurrentState();
    }

    private Date getLastStateTransitionTime() {
        return this.cachedEntry.getLastStateTransitionTime();
    }

    private Date getLastSuccessSynchronizationTime() {
        return this.cachedEntry.getLastSuccessSynchronizationTime();
    }

    private String getCachedExceptionMessage() {
        return this.cachedEntry.getExceptionMessage();
    }

    private String getCachedExceptionStackTrace() {
        return this.cachedEntry.getExceptionStackTrace();
    }

    private Date getCachedExceptionFirstOccurrenceTime() {
        return this.cachedEntry.getExceptionFirstOccurrenceTime();
    }

    private Date getCachedExceptionLastOccurrenceTime() {
        return this.cachedEntry.getExceptionLastOccurrenceTime();
    }
}

