/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.validation;

import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.tsl.cache.CachedResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ValidationResult
implements CachedResult {
    private final CertificateSource certificateSource;
    private Indication indication;
    private SubIndication subIndication;
    private Date signingTime;
    private CertificateToken signingCertificate;

    public ValidationResult(Indication indication, SubIndication subIndication, Date signingTime, CertificateToken signingCertificate, CertificateSource certificateSource) {
        this.indication = indication;
        this.subIndication = subIndication;
        this.signingTime = signingTime;
        this.signingCertificate = signingCertificate;
        this.certificateSource = certificateSource;
    }

    public Indication getIndication() {
        return this.indication;
    }

    public SubIndication getSubIndication() {
        return this.subIndication;
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    public CertificateToken getSigningCertificate() {
        return this.signingCertificate;
    }

    public List<CertificateToken> getPotentialSigners() {
        return new ArrayList<CertificateToken>(this.certificateSource.getCertificates());
    }
}

