/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.List;

public abstract class Chain<T extends XmlConstraintsConclusion> {
    protected final T result;
    protected final I18nProvider i18nProvider;
    protected ChainItem<T> firstItem;

    protected Chain(I18nProvider i18nProvider, T newInstance) {
        this.i18nProvider = i18nProvider;
        this.result = newInstance;
    }

    public T execute() {
        this.initChain();
        if (this.firstItem != null) {
            this.firstItem.execute();
        }
        ((XmlConstraintsConclusion)this.result).setTitle(this.buildChainTitle());
        if (((XmlConstraintsConclusion)this.result).getConclusion() == null) {
            XmlConclusion conclusion = new XmlConclusion();
            conclusion.setIndication(Indication.PASSED);
            ((XmlConstraintsConclusion)this.result).setConclusion(conclusion);
        }
        this.collectMessages();
        this.addAdditionalInfo();
        return this.result;
    }

    protected String buildChainTitle() {
        return ValidationProcessUtils.buildStringMessage(this.i18nProvider, this.getTitle(), new Object[0]);
    }

    protected MessageTag getTitle() {
        return null;
    }

    protected void addAdditionalInfo() {
    }

    protected abstract void initChain();

    protected boolean isValid(XmlConstraintsConclusion constraintConclusion) {
        return constraintConclusion != null && this.isValidConclusion(constraintConclusion.getConclusion());
    }

    protected boolean isValidConclusion(XmlConclusion conclusion) {
        return conclusion != null && Indication.PASSED.equals(conclusion.getIndication());
    }

    protected LevelConstraint getFailLevelConstraint() {
        LevelConstraint constraint = new LevelConstraint();
        constraint.setLevel(Level.FAIL);
        return constraint;
    }

    protected LevelConstraint getWarnLevelConstraint() {
        LevelConstraint constraint = new LevelConstraint();
        constraint.setLevel(Level.WARN);
        return constraint;
    }

    protected LevelConstraint getInfoLevelConstraint() {
        LevelConstraint constraint = new LevelConstraint();
        constraint.setLevel(Level.INFORM);
        return constraint;
    }

    private void collectMessages() {
        XmlConclusion conclusion = ((XmlConstraintsConclusion)this.result).getConclusion();
        List<XmlConstraint> constraints = ((XmlConstraintsConclusion)this.result).getConstraint();
        for (XmlConstraint constraint : constraints) {
            this.collectMessages(conclusion, constraint);
        }
        this.collectAdditionalMessages(conclusion);
    }

    protected void collectMessages(XmlConclusion conclusion, XmlConstraint constraint) {
        XmlMessage info;
        XmlMessage warning = constraint.getWarning();
        if (warning != null) {
            conclusion.getWarnings().add(warning);
        }
        if ((info = constraint.getInfo()) != null) {
            conclusion.getInfos().add(info);
        }
    }

    protected void collectAllMessages(XmlConclusion conclusionToFill, XmlConclusion conclusionToFillFrom) {
        List<XmlMessage> infos;
        List<XmlMessage> warnings;
        List<XmlMessage> errors = conclusionToFillFrom.getErrors();
        if (errors != null) {
            conclusionToFill.getErrors().addAll(errors);
        }
        if ((warnings = conclusionToFillFrom.getWarnings()) != null) {
            conclusionToFill.getWarnings().addAll(warnings);
        }
        if ((infos = conclusionToFillFrom.getInfos()) != null) {
            conclusionToFill.getInfos().addAll(infos);
        }
    }

    protected void collectAdditionalMessages(XmlConclusion conclusion) {
    }
}

