/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.policy.jaxb.Algo;
import eu.europa.esig.dss.policy.jaxb.AlgoExpirationDate;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.ListAlgo;
import eu.europa.esig.dss.utils.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicConstraintWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicConstraintWrapper.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private final CryptographicConstraint constraint;

    public CryptographicConstraintWrapper(CryptographicConstraint constraint) {
        this.constraint = constraint;
    }

    public boolean isEncryptionAlgorithmReliable(EncryptionAlgorithm encryptionAlgorithm) {
        ListAlgo acceptableEncryptionAlgos;
        if (encryptionAlgorithm != null && this.constraint != null && (acceptableEncryptionAlgos = this.constraint.getAcceptableEncryptionAlgo()) != null) {
            for (Algo algo : acceptableEncryptionAlgos.getAlgos()) {
                if (!algo.getValue().equals(encryptionAlgorithm.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDigestAlgorithmReliable(DigestAlgorithm digestAlgorithm) {
        ListAlgo acceptableEncryptionAlgos;
        if (digestAlgorithm != null && this.constraint != null && (acceptableEncryptionAlgos = this.constraint.getAcceptableDigestAlgo()) != null) {
            for (Algo algo : acceptableEncryptionAlgos.getAlgos()) {
                if (!algo.getValue().equals(digestAlgorithm.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEncryptionAlgorithmWithKeySizeReliable(EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        Integer size;
        int keySize = this.parseKeySize(keyLength);
        return encryptionAlgorithm != null && keySize != 0 && this.constraint != null && (size = this.getAlgoKeySizeFromConstraint(encryptionAlgorithm)) != null && size <= keySize;
    }

    private Integer getAlgoKeySizeFromConstraint(EncryptionAlgorithm encryptionAlgorithm) {
        ListAlgo miniPublicKeySize = this.constraint.getMiniPublicKeySize();
        if (miniPublicKeySize != null) {
            for (Algo algo : miniPublicKeySize.getAlgos()) {
                if (!algo.getValue().equals(encryptionAlgorithm.getName())) continue;
                return algo.getSize();
            }
        }
        return null;
    }

    public Date getExpirationDate(EncryptionAlgorithm encryptionAlgorithm, String keyLength) {
        int keySize;
        Map.Entry floorEntry;
        TreeMap<Integer, Date> dates = new TreeMap<Integer, Date>();
        AlgoExpirationDate algoExpirationDates = this.getAlgoExpirationDates();
        if (algoExpirationDates != null && encryptionAlgorithm != null) {
            SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
            String algoToSearch = encryptionAlgorithm.getName();
            for (Algo algo : algoExpirationDates.getAlgos()) {
                if (!algo.getValue().equals(algoToSearch)) continue;
                dates.put(algo.getSize(), this.getDate(algo, dateFormat));
            }
        }
        if ((floorEntry = dates.floorEntry(keySize = this.parseKeySize(keyLength))) == null) {
            return null;
        }
        return (Date)floorEntry.getValue();
    }

    public Date getExpirationDate(DigestAlgorithm digestAlgorithm) {
        AlgoExpirationDate algoExpirationDates = this.getAlgoExpirationDates();
        if (algoExpirationDates != null && digestAlgorithm != null) {
            SimpleDateFormat dateFormat = this.getUsedDateFormat(algoExpirationDates);
            String algoToFind = digestAlgorithm.getName();
            for (Algo algo : algoExpirationDates.getAlgos()) {
                if (!algo.getValue().equals(algoToFind)) continue;
                return this.getDate(algo, dateFormat);
            }
        }
        return null;
    }

    private int parseKeySize(String keyLength) {
        return Utils.isStringDigits(keyLength) ? Integer.parseInt(keyLength) : 0;
    }

    private AlgoExpirationDate getAlgoExpirationDates() {
        if (this.constraint != null) {
            return this.constraint.getAlgoExpirationDate();
        }
        return null;
    }

    private SimpleDateFormat getUsedDateFormat(AlgoExpirationDate expirations) {
        return new SimpleDateFormat(Utils.isStringEmpty(expirations.getFormat()) ? DEFAULT_DATE_FORMAT : expirations.getFormat());
    }

    private Date getDate(Algo algo, SimpleDateFormat format) {
        String date = algo.getDate();
        if (date != null) {
            try {
                return format.parse(date);
            }
            catch (ParseException e) {
                LOG.warn("Unable to parse '{}' with format '{}'", (Object)date, (Object)format);
            }
        }
        return null;
    }

    public CryptographicConstraint getConstraint() {
        return this.constraint;
    }
}

