/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class RevocationConsistentCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    protected final CertificateWrapper certificate;
    protected final RevocationWrapper revocationData;
    protected Date thisUpdate;
    protected Date producedAt;
    protected Date certNotBefore;
    protected Date certNotAfter;
    protected Date notAfterRevoc;
    protected boolean certHashOK;

    public RevocationConsistentCheck(I18nProvider i18nProvider, T result, CertificateWrapper certificate, RevocationWrapper revocationData, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, revocationData.getId());
        this.certificate = certificate;
        this.revocationData = revocationData;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.REV_CC;
    }

    @Override
    protected boolean process() {
        Date expiredCertsRevocationInfo;
        CertificateWrapper revocCert;
        Date archiveCutOff;
        this.certNotBefore = this.certificate.getNotBefore();
        this.certNotAfter = this.certificate.getNotAfter();
        this.thisUpdate = this.revocationData.getThisUpdate();
        this.producedAt = this.revocationData.getProductionDate();
        this.notAfterRevoc = this.thisUpdate;
        Date expiredCertsOnCRL = this.revocationData.getExpiredCertsOnCRL();
        if (expiredCertsOnCRL != null) {
            this.notAfterRevoc = expiredCertsOnCRL;
        }
        if ((archiveCutOff = this.revocationData.getArchiveCutOff()) != null) {
            this.notAfterRevoc = archiveCutOff;
        }
        if ((expiredCertsOnCRL != null || archiveCutOff != null) && (revocCert = this.revocationData.getSigningCertificate()) != null && (expiredCertsRevocationInfo = revocCert.getCertificateTSPServiceExpiredCertsRevocationInfo()) != null && expiredCertsRevocationInfo.before(this.notAfterRevoc)) {
            this.notAfterRevoc = expiredCertsRevocationInfo;
        }
        this.certHashOK = this.revocationData.isCertHashExtensionPresent() && this.revocationData.isCertHashExtensionMatch();
        return this.checkThisUpdateDefined() && this.checkRevocationDataHasInformationAboutCertificate() && this.checkIssuerKnowsCertificate() && this.checkRevocationIssuerKnown() && this.checkIssuerValidAtProductionTime();
    }

    private boolean checkThisUpdateDefined() {
        return this.thisUpdate != null;
    }

    private boolean checkRevocationDataHasInformationAboutCertificate() {
        return this.certNotBefore.compareTo(this.thisUpdate) <= 0;
    }

    private boolean checkIssuerKnowsCertificate() {
        return this.checkIssuerHasInformationForExpiredCertificate() || this.checkCertHashMatches();
    }

    private boolean checkIssuerHasInformationForExpiredCertificate() {
        return this.certNotAfter.compareTo(this.notAfterRevoc) >= 0;
    }

    private boolean checkCertHashMatches() {
        return this.certHashOK;
    }

    private boolean checkRevocationIssuerKnown() {
        return this.revocationData.getSigningCertificate() != null;
    }

    private boolean checkIssuerValidAtProductionTime() {
        return !RevocationType.OCSP.equals((Object)this.revocationData.getRevocationType()) || this.checkOCSPResponderValidAtRevocationProductionTime();
    }

    private boolean checkOCSPResponderValidAtRevocationProductionTime() {
        CertificateWrapper revocationIssuer = this.revocationData.getSigningCertificate();
        return this.producedAt.compareTo(revocationIssuer.getNotBefore()) >= 0 && this.producedAt.compareTo(revocationIssuer.getNotAfter()) <= 0;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_IRDC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_IRDC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (!this.checkThisUpdateDefined()) {
            return this.getNoThisUpdateMessage();
        }
        if (!this.checkRevocationDataHasInformationAboutCertificate()) {
            return this.getThisUpdateBeforeCertificateNotBeforeMessage();
        }
        if (!this.checkIssuerKnowsCertificate()) {
            return this.getNotAfterAfterCertificateNotAfterMessage();
        }
        if (!this.checkRevocationIssuerKnown()) {
            return this.getRevocationIssuerNotFoundMessage();
        }
        if (!this.checkIssuerValidAtProductionTime()) {
            return this.getRevocationProducesAtOutOfBoundsMessage();
        }
        if (this.checkCertHashMatches()) {
            return this.getRevocationCertHashOkMessage();
        }
        return this.getRevocationConsistentMessage();
    }

    protected String getNoThisUpdateMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_NO_THIS_UPDATE, new Object[0]);
    }

    protected String getThisUpdateBeforeCertificateNotBeforeMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_THIS_UPDATE_BEFORE, ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }

    protected String getNotAfterAfterCertificateNotAfterMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_NOT_AFTER_AFTER, ValidationProcessUtils.getFormattedDate(this.notAfterRevoc), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }

    protected String getRevocationIssuerNotFoundMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_ISSUER_NOT_FOUND, new Object[0]);
    }

    protected String getRevocationProducesAtOutOfBoundsMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_PRODUCED_AT_OUT_OF_BOUNDS, ValidationProcessUtils.getFormattedDate(this.producedAt), ValidationProcessUtils.getFormattedDate(this.revocationData.getSigningCertificate().getNotBefore()), ValidationProcessUtils.getFormattedDate(this.revocationData.getSigningCertificate().getNotAfter()));
    }

    protected String getRevocationCertHashOkMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CERT_HASH_OK, new Object[0]);
    }

    protected String getRevocationConsistentMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CONSISTENT, ValidationProcessUtils.getFormattedDate(this.thisUpdate), ValidationProcessUtils.getFormattedDate(this.certNotBefore), ValidationProcessUtils.getFormattedDate(this.certNotAfter));
    }
}

