/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfbs.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class BasicValidationProcessCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final XmlConclusion xmlConclusion;

    public BasicValidationProcessCheck(I18nProvider i18nProvider, T result, XmlConclusion xmlConclusion, TokenProxy token, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, token.getId());
        this.xmlConclusion = xmlConclusion;
    }

    @Override
    protected boolean process() {
        return this.isValidConclusion(this.xmlConclusion);
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.xmlConclusion.getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.xmlConclusion.getSubIndication();
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_ROBVPIIC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_ROBVPIIC_ANS;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (!this.isValidConclusion(this.xmlConclusion)) {
            String indication = String.format("%s/%s", this.xmlConclusion.getIndication(), this.xmlConclusion.getSubIndication());
            return this.i18nProvider.getMessage(MessageTag.BASIC_SIGNATURE_VALIDATION_RESULT, indication);
        }
        return null;
    }
}

