/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.util.Date;

public class POEExistsAtOrBeforeControlTimeCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final TokenProxy token;
    private final TimestampedObjectType referenceCategory;
    private final Date controlTime;
    private final POEExtraction poe;

    public POEExistsAtOrBeforeControlTimeCheck(I18nProvider i18nProvider, T result, TokenProxy token, TimestampedObjectType referenceCategory, Date controlTime, POEExtraction poe, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.token = token;
        this.referenceCategory = referenceCategory;
        this.controlTime = controlTime;
        this.poe = poe;
    }

    @Override
    protected boolean process() {
        return this.poe.isPOEExists(this.token.getId(), this.controlTime);
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.CONTROL_TIME, this.token.getId(), ValidationProcessUtils.getFormattedDate(this.controlTime));
    }

    @Override
    protected MessageTag getMessageTag() {
        if (TimestampedObjectType.CERTIFICATE.equals((Object)this.referenceCategory)) {
            return MessageTag.PSV_ITPOCOBCT;
        }
        if (TimestampedObjectType.REVOCATION.equals((Object)this.referenceCategory)) {
            return MessageTag.PSV_ITPORDAOBCT;
        }
        throw new IllegalStateException("Problem VTS");
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_ITPOOBCT_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_POE;
    }
}

