/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class RevocationIssuedBeforeControlTimeCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final RevocationWrapper revocation;
    private final Date controlTime;

    public RevocationIssuedBeforeControlTimeCheck(I18nProvider i18nProvider, T result, RevocationWrapper revocation, Date controlTime, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.revocation = revocation;
        this.controlTime = controlTime;
    }

    @Override
    protected boolean process() {
        return this.revocation.getThisUpdate() != null && this.revocation.getThisUpdate().before(this.controlTime);
    }

    @Override
    protected String buildAdditionalInfo() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_THIS_UPDATE_CONTROL_TIME, this.revocation.getId(), this.revocation.getThisUpdate() != null ? ValidationProcessUtils.getFormattedDate(this.revocation.getThisUpdate()) : null, ValidationProcessUtils.getFormattedDate(this.controlTime));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_HRDBIBCT;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_HRDBIBCT_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return null;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

