/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.scope;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;

public abstract class AbstractSignatureScopeFinder {
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private static final String ASICS_PACKAGE_ZIP_NAME = "package.zip";

    public void setDefaultDigestAlgorithm(DigestAlgorithm defaultDigestAlgorithm) {
        this.defaultDigestAlgorithm = defaultDigestAlgorithm;
    }

    protected DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }

    protected Digest getDigest(DSSDocument document) {
        return new Digest(this.defaultDigestAlgorithm, Utils.fromBase64(document.getDigest(this.defaultDigestAlgorithm)));
    }

    protected Digest getDigest(byte[] dataBytes) {
        return new Digest(this.defaultDigestAlgorithm, DSSUtils.digest(this.defaultDigestAlgorithm, dataBytes));
    }

    protected boolean isASiCSArchive(AdvancedSignature advancedSignature, DSSDocument signedDocument) {
        return ASICS_PACKAGE_ZIP_NAME.equals(signedDocument.getName()) && Utils.isCollectionNotEmpty(advancedSignature.getContainerContents());
    }

    protected boolean isASiCEArchive(AdvancedSignature advancedSignature) {
        return advancedSignature.getManifestFile() != null;
    }
}

