/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Attribute;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESSignaturePolicy;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import eu.europa.esig.dss.xades.validation.policy.XMLSignaturePolicyValidator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SignaturePolicyStoreBuilder
extends ExtensionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SignaturePolicyStoreBuilder.class);

    protected SignaturePolicyStoreBuilder(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument signatureDocument, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(signaturePolicyStore, "SignaturePolicyStore must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification(), "SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification().getId(), "ID (OID or URI) for SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSignaturePolicyContent(), "Signature policy content must be provided");
        this.params = new XAdESSignatureParameters();
        this.documentValidator = new XMLDocumentValidator(signatureDocument);
        this.documentDom = this.documentValidator.getRootElement();
        for (AdvancedSignature signature : this.documentValidator.getSignatures()) {
            XAdESSignature xadesSignature = this.initializeSignatureBuilder((XAdESSignature)signature);
            String currentSignatureId = xadesSignature.getDAIdentifier();
            this.ensureUnsignedProperties();
            this.ensureUnsignedSignatureProperties();
            XAdESSignaturePolicy signaturePolicy = xadesSignature.getSignaturePolicy();
            if (signaturePolicy != null) {
                signaturePolicy.setPolicyContent(signaturePolicyStore.getSignaturePolicyContent());
                Digest digest = signaturePolicy.getDigest();
                if (digest != null) {
                    Digest computedDigest;
                    try {
                        SignaturePolicyValidator validator = this.documentValidator.getSignaturePolicyValidatorLoader().loadValidator(signaturePolicy);
                        if (validator instanceof XMLSignaturePolicyValidator) {
                            XMLSignaturePolicyValidator xmlSignaturePolicyValidator = (XMLSignaturePolicyValidator)validator;
                            computedDigest = xmlSignaturePolicyValidator.getDigestAfterTransforms(signaturePolicyStore.getSignaturePolicyContent(), digest.getAlgorithm(), signaturePolicy.getTransforms());
                        } else {
                            computedDigest = validator.getComputedDigest(signaturePolicyStore.getSignaturePolicyContent(), digest.getAlgorithm());
                        }
                    }
                    catch (Exception e) {
                        throw new DSSException(String.format("Unable to compute digest for a SignaturePolicyStore. Reason : %s", e.getMessage()), e);
                    }
                    if (digest.equals(computedDigest)) {
                        Element signaturePolicyStoreElement = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, this.getXades141Namespace(), XAdES141Element.SIGNATURE_POLICY_STORE);
                        if (signaturePolicyStore.getId() != null) {
                            signaturePolicyStoreElement.setAttribute(XAdES141Attribute.ID.getAttributeName(), signaturePolicyStore.getId());
                        }
                        SpDocSpecification spDocSpecification = signaturePolicyStore.getSpDocSpecification();
                        this.incorporateSPDocSpecification(signaturePolicyStoreElement, spDocSpecification);
                        Element policyDocElement = DomUtils.addElement(this.documentDom, signaturePolicyStoreElement, this.getXades141Namespace(), XAdES141Element.SIGNATURE_POLICY_DOCUMENT);
                        DomUtils.setTextNode(this.documentDom, policyDocElement, Utils.toBase64(DSSUtils.toByteArray(signaturePolicyStore.getSignaturePolicyContent())));
                        continue;
                    }
                    LOG.warn("Signature policy's digest doesn't match the document {} for signature {}", (Object)digest, (Object)currentSignatureId);
                    continue;
                }
                LOG.warn("No defined digest for signature {}", (Object)currentSignatureId);
                continue;
            }
            LOG.warn("No defined SignaturePolicyIdentifier for signature {}", (Object)currentSignatureId);
        }
        return this.createXmlDocument();
    }
}

