/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.definition.XAdESElement;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Element;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Paths;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Element;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Paths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Attribute;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Paths;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.reference.DSSReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XAdESBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESBuilder.class);
    public static final String REFERENCED_DATA = "referencedData";
    public static final String TARGET = "Target";
    public static final String URI = "URI";
    protected XAdESPaths xadesPaths;
    protected XAdESSignatureParameters params;
    protected Document documentDom;
    protected CertificateVerifier certificateVerifier;

    protected XAdESBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    protected void incorporateCertDigest(Element parentDom, DigestAlgorithm digestAlgorithm, Token token) {
        Element certDigestDom = DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCertDigest());
        this.incorporateDigestMethod(certDigestDom, digestAlgorithm);
        this.incorporateDigestValue(certDigestDom, digestAlgorithm, token);
    }

    protected void incorporateDigestMethod(Element parentDom, DigestAlgorithm digestAlgorithm) {
        DSSNamespace namespace = this.getDigestAlgAndValueNamespace();
        DSSXMLUtils.incorporateDigestMethod(parentDom, digestAlgorithm, namespace);
    }

    protected void incorporateDigestValue(Element parentDom, DigestAlgorithm digestAlgorithm, Token token) {
        String base64EncodedDigestBytes = Utils.toBase64(token.getDigest(digestAlgorithm));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Digest value for the token with Id [{}] --> {}", (Object)token.getDSSIdAsString(), (Object)base64EncodedDigestBytes);
        }
        this.incorporateDigestValue(parentDom, base64EncodedDigestBytes);
    }

    protected void incorporateDigestValue(Element parentDom, String base64EncodedDigestBytes) {
        DSSNamespace namespace = this.getDigestAlgAndValueNamespace();
        DSSXMLUtils.incorporateDigestValue(parentDom, base64EncodedDigestBytes, namespace);
    }

    private DSSNamespace getDigestAlgAndValueNamespace() {
        return XAdESNamespaces.XADES_111.isSameUri(this.getXadesNamespace().getUri()) ? this.getXadesNamespace() : this.getXmldsigNamespace();
    }

    protected Element incorporateCert(Element parentDom, CertificateToken certificate, DigestAlgorithm digestAlgorithm) {
        Element certDom = DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCert());
        this.incorporateCertDigest(certDom, digestAlgorithm, certificate);
        if (this.params.isEn319132()) {
            this.incorporateIssuerV2(certDom, certificate);
        } else {
            this.incorporateIssuerV1(certDom, certificate);
        }
        return certDom;
    }

    protected void incorporateIssuerV1(Element parentDom, CertificateToken certificate) {
        Element issuerSerialDom = DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIssuerSerial());
        Element x509IssuerNameDom = DomUtils.addElement(this.documentDom, issuerSerialDom, this.getXmldsigNamespace(), XMLDSigElement.X509_ISSUER_NAME);
        String issuerX500PrincipalName = certificate.getIssuerX500Principal().getName();
        DomUtils.setTextNode(this.documentDom, x509IssuerNameDom, issuerX500PrincipalName);
        Element x509SerialNumberDom = DomUtils.addElement(this.documentDom, issuerSerialDom, this.getXmldsigNamespace(), XMLDSigElement.X509_SERIAL_NUMBER);
        BigInteger serialNumber = certificate.getSerialNumber();
        String serialNumberString = serialNumber.toString();
        DomUtils.setTextNode(this.documentDom, x509SerialNumberDom, serialNumberString);
    }

    protected void incorporateIssuerV2(Element parentDom, CertificateToken certificate) {
        Element issuerSerialDom = DomUtils.addElement(this.documentDom, parentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIssuerSerialV2());
        IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial(certificate);
        String issuerBase64 = Utils.toBase64(DSSASN1Utils.getDEREncoded(issuerSerial));
        DomUtils.setTextNode(this.documentDom, issuerSerialDom, issuerBase64);
    }

    private List<String> getNotIndentedObjectIds() {
        ArrayList<String> ids = new ArrayList<String>();
        List<DSSReference> dssReferences = this.params.getReferences();
        if (dssReferences != null) {
            for (DSSReference reference : dssReferences) {
                if (!DSSXMLUtils.isObjectReferenceType(reference.getType())) continue;
                ids.add(DomUtils.getId(reference.getUri()));
            }
        }
        return ids;
    }

    protected DigestAlgorithm getReferenceDigestAlgorithmOrDefault(XAdESSignatureParameters params) {
        return params.getReferenceDigestAlgorithm() != null ? params.getReferenceDigestAlgorithm() : params.getDigestAlgorithm();
    }

    protected DSSDocument createXmlDocument() {
        byte[] bytes;
        if (SigningOperation.SIGN.equals((Object)this.params.getContext().getOperationKind()) && this.params.isPrettyPrint()) {
            this.alignNodes();
            bytes = DSSXMLUtils.serializeNode(DSSXMLUtils.getDocWithIndentedSignature(this.documentDom, this.params.getDeterministicId(), this.getNotIndentedObjectIds()));
        } else {
            bytes = DSSXMLUtils.serializeNode(this.documentDom);
        }
        InMemoryDocument inMemoryDocument = new InMemoryDocument(bytes);
        inMemoryDocument.setMimeType(MimeType.XML);
        return inMemoryDocument;
    }

    protected abstract void alignNodes();

    protected DSSNamespace getXmldsigNamespace() {
        return this.params.getXmldsigNamespace();
    }

    protected DSSNamespace getXadesNamespace() {
        return this.params.getXadesNamespace();
    }

    protected DSSNamespace getXades141Namespace() {
        return this.params.getXades141Namespace();
    }

    protected XAdESElement getCurrentXAdESElements() {
        String xadesURI = this.getXadesNamespace().getUri();
        if (XAdESNamespaces.XADES_132.getUri().equals(xadesURI)) {
            return XAdES132Element.values()[0];
        }
        if (XAdESNamespaces.XADES_122.getUri().equals(xadesURI)) {
            return XAdES122Element.values()[0];
        }
        if (XAdESNamespaces.XADES_111.getUri().equals(xadesURI)) {
            return XAdES111Element.values()[0];
        }
        throw new IllegalArgumentException("Unsupported URI : " + xadesURI);
    }

    protected XAdESPaths getCurrentXAdESPaths() {
        String xadesURI = this.getXadesNamespace().getUri();
        if (Utils.areStringsEqual(XAdESNamespaces.XADES_132.getUri(), xadesURI)) {
            return new XAdES132Paths();
        }
        if (Utils.areStringsEqual(XAdESNamespaces.XADES_122.getUri(), xadesURI)) {
            return new XAdES122Paths();
        }
        if (Utils.areStringsEqual(XAdESNamespaces.XADES_111.getUri(), xadesURI)) {
            return new XAdES111Paths();
        }
        throw new IllegalArgumentException("Unsupported URI : " + xadesURI);
    }

    protected void incorporateSPDocSpecification(Element parentElement, SpDocSpecification spDocSpecification) {
        Element spDocSpecElement = DomUtils.addElement(this.documentDom, parentElement, this.getXades141Namespace(), XAdES141Element.SP_DOC_SPECIFICATION);
        DomUtils.addNamespaceAttribute(spDocSpecElement, this.getXades141Namespace());
        Element identifierElement = DomUtils.addElement(this.documentDom, spDocSpecElement, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIdentifier());
        if (spDocSpecification.getQualifier() != null) {
            identifierElement.setAttribute(XAdES132Attribute.QUALIFIER.getAttributeName(), spDocSpecification.getQualifier().getValue());
        }
        DomUtils.setTextNode(this.documentDom, identifierElement, spDocSpecification.getId());
        if (Utils.isStringNotEmpty(spDocSpecification.getDescription())) {
            Element descriptionElement = DomUtils.addElement(this.documentDom, spDocSpecElement, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDescription());
            DomUtils.setTextNode(this.documentDom, descriptionElement, spDocSpecification.getDescription());
        }
        if (Utils.isArrayNotEmpty(spDocSpecification.getDocumentationReferences())) {
            Element documentReferencesElement = DomUtils.addElement(this.documentDom, spDocSpecElement, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDocumentationReferences());
            for (String docRef : spDocSpecification.getDocumentationReferences()) {
                Element documentReferenceElement = DomUtils.addElement(this.documentDom, documentReferencesElement, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDocumentationReference());
                DomUtils.setTextNode(this.documentDom, documentReferenceElement, docRef);
            }
        }
    }
}

