/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.scope;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.validation.scope.SignatureScopeWithTransformations;
import java.util.List;

public class XPointerSignatureScope
extends SignatureScopeWithTransformations {
    private static final long serialVersionUID = 203530674533107438L;
    private final String uri;

    protected XPointerSignatureScope(String uri, List<String> transformations, Digest digest) {
        super(XPointerSignatureScope.getDocumentNameFromXPointer(uri), digest, transformations);
        this.uri = uri;
    }

    private static String getDocumentNameFromXPointer(String uri) {
        return DomUtils.isRootXPointer(uri) ? "Full XML file" : DomUtils.getXPointerId(uri);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder("XPointer query to ");
        if (DomUtils.isRootXPointer(this.uri)) {
            sb.append("root XML element");
        } else {
            sb.append("element with Id '");
            sb.append(this.getName());
            sb.append("'");
        }
        return this.addTransformationIfNeeded(sb.toString());
    }

    @Override
    public SignatureScopeType getType() {
        return DomUtils.isRootXPointer(this.uri) ? SignatureScopeType.FULL : SignatureScopeType.PARTIAL;
    }
}

